#include <iostream>
#include <vector>
#include <cstdio>
#include <cstdlib>
#include <string>
#include <cmath>
#include <cassert>
#include <algorithm>
#include <set>
#include <map>
#include <queue>

#define forn(i, n) for (int i = 0; i < (int)n; i++)
#define fore(i, b, e) for (int i = (int)b; i <= (int)e; i++)
#define fi first
#define se second
#define mp make_pair
#define pb push_back

#define TASKNAME "coco"

typedef long long i64;
typedef long long li;
typedef long long lint;

using namespace std;

const int INF = 2000000001;

vector<int> g[100100];
vector<int> c[100100];
vector<int> num[100100];
bool good[100100];
int n, m;
int d1[100100];
int d2[100100];

void dijkstra(int start, int *d){
	for (int i = 0; i < n; i++)
		d[i] = INF;
	d[start] = 0;
	priority_queue<pair<int, int> > q;
	q.push(make_pair(0, start));
	while (!q.empty()) {
		pair<int, int> cur = q.top();
		q.pop();
		int v = cur.second, dist = -cur.first;
		if (d[v] != dist)
			continue;
		for (int i = 0; i < (int)g[v].size(); i++) {
			int to = g[v][i];
			if (d[v] + c[v][i] < d[to]) {
				d[to] = d[v] + c[v][i];
				q.push(make_pair(-d[to], to));
			}
		}
	}
}

struct event {
	event() { }
	event(int _x, int _t, int _num) {
		x = _x;
		t = _t;
		num = _num;
	}

	int x;
	int t;
	int num;
};
event a[100100];
int na = 0;

bool cmp(event a, event b) {
	if (a.x < b.x)
		return true;
	if (a.x > b.x)
		return false;
	if (a.t == 0)
		return true;
	return false;
}

vector<int> res;

int main()
{
	freopen("exploring.in", "r", stdin);
	freopen("exploring.out", "w", stdout);
	cin >> n >> m;
	for (int i = 0; i < m; i++) {
		int u, v, cost;
		cin >> u >> v >> cost;
		u--, v--;
		g[u].push_back(v);
		c[u].push_back(cost);
		g[v].push_back(u);
		c[v].push_back(cost);
		num[v].push_back(i + 1);
		num[u].push_back(i + 1);
	}

	dijkstra(0, d1);
	dijkstra(n - 1, d2);
	for (int v = 0; v < n; v++) {
		for (int i = 0; i < (int)g[v].size(); i++) {
			int to = g[v][i];
			if ((li)d1[v] + (li)c[v][i] + (li)d2[to] == (li)d1[n - 1]) {
				good[num[v][i]] = true;
				//cerr << v << ' ' << to << endl;
				a[na] = event(d1[v], 0, num[v][i]);
				na++;
				a[na] = event(d1[to], 1, num[v][i]);
				na++;
			}
		}
	}

	sort(a, a + na, cmp);

	/*for (int i = 0; i < na; i++)
		cerr << a[i].num << ' ';
	cerr << endl;*/

	set<int> opened;
	for (int i = 0; i < na; i++) {
		int cur = i;
		while (a[i].x == a[cur].x) {
			if (a[i].t == 0) {
				opened.insert(a[i].num);
			} else {
				opened.erase(a[i].num);
			}
			i++;
			if (i == n)
				break;
		}
		i--;
		//cerr << i << ' ' << opened.size() << endl;
		if (opened.size() == 1) {
			res.push_back(*opened.begin());
		}
	}
	sort(res.begin(), res.end());
	res.resize(unique(res.begin(), res.end()) - res.begin());
	cout << res.size() << endl;
	for (int i = 0; i < (int)res.size(); i++)
		cout << res[i] << ' ';
	cout << endl;
}